open Shell


type targ = Complete | MLFile | CFile

let compile makefile out homedir t =
  let outfile = 
    match out with
	Some x -> x
      | None -> match t with 
	    Complete -> "a.out"
	  | CFile -> (Filename.chop_extension makefile) ^ ".c"
	  | MLFile -> (Filename.chop_extension makefile) ^ ".ml"
  in
  let runfile = Filename.temp_file "mkc" ".exe" in
  let cfile = Filename.temp_file "mkc" ".c" in
  let toast x = try Unix.unlink x with _ -> () in
  let tidyup _ = (toast cfile; toast runfile) in
    try
      begin
	tidyup ();
	match t with
	    Complete | CFile -> 
	      call [cmd "ocamlc" ["-pp"; homedir ^ "/mkc-fe -impl"; 
				  "-o"; runfile; "-I"; homedir;
				  "-I"; "frontc"; "frontc.cma"; "be.cmo"; 
				  "-impl"; makefile ]];
	      Unix.chmod runfile 0o700;
	      if t = CFile 
	      then
		call ~stdout:(to_file outfile) [cmd runfile []]
	      else
		begin
		  call ~stdout:(to_file cfile) [cmd runfile []];
		  call [cmd "gcc" ["-O2"; "-o"; outfile; cfile]];
		  Unix.chmod outfile 0o755;
		end;
	      tidyup ()
	  | MLFile -> call ~stdout:(to_file outfile) 
	      [cmd (homedir ^ "/mkc-fe") ["pr_o.cmo"; "-impl"; makefile]]
      end
    with
	_ -> tidyup ()
;;

let output_file = ref None;;
let target = ref Complete;;

let args = [

  ("-o", 
   Arg.String (fun x -> output_file := Some x),  
   "set output file");

  ("-m", 
   Arg.Unit (fun _ -> target := MLFile),  
   "compile to ML file");

  ("-c", 
   Arg.Unit (fun _ -> target := CFile),  
   "compile to ML, then C file");

  ("-version", 
   Arg.Unit (fun _ -> Printf.printf "mkc version $Id: driver.ml,v 1.7 2002/04/29 06:37:16 graydon Exp $\n"),  
   "display version")
]
;;

let _ = 
  Arg.parse args (fun x -> compile x !output_file "." !target) 
      (Printf.sprintf "usage: %s [options] <input.mk>\n%s\n" 
	 Sys.argv.(0) "where options is one of:")
	 



